package kb.presentation;

// enhydra imports
import org.enhydra.xml.xmlc.*;
import org.w3c.dom.*;
import org.w3c.dom.html.*;
import com.lutris.appserver.server.sql.*;
import com.lutris.appserver.server.Enhydra;
import com.lutris.appserver.server.httpPresentation.*;
import com.lutris.logging.*;
import kb.presentation.*;
import kb.business.*;

public abstract class BasePO implements HttpPresentation {

    /**
     * Instantiates the create method using xmlc Factory.
     * 
     * 
     * @param poName
     * 
     * @return
     * 
     * @throws Exception
     * 
     * @see
     */
    public XMLObject create(HttpPresentationComms comms, String poName) {
        XMLObject page = null;

        try {
            page = comms.xmlcFactory.create(getPageName(comms, poName));
        } catch (Exception ex) {
            System.out.println("Trouble creating page" + ex);
        } 
        return page;
    } 

    /**
     * Gets the suffix of a PO name based on the
     * accept type.
     * @param String PO classname
     * @return PO new full classname with suffix.
     */
    public String getPageName(HttpPresentationComms comms, String poName) {
        String header = null;

        try {
            if ((header = comms.request.getHeader("Accept")) == null) {

                // Can't decipher accept type.
                return null;
            } else if (header.indexOf("text/xml") != -1) {
                return poName + "XML";
            } else if (header.indexOf("text/vnd.wap.wml") != -1) {
                return poName + "WML";
            } else {
                return poName + "HTML";
            } 
        } catch (Exception e) {
            System.out.println("Trouble getting proper name:" + e);
            return null;
        } 
    } 
}
